﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Reflection;
using System.IO;
using Microsoft.Win32;
using System.Data.Odbc;
using VSLangProj;
using System.Xml.Serialization;
using Model;
using System.Data;
//using ServiceStack.OrmLite;
using System.Net;
using System.Threading;
using System.Globalization;

namespace PsgServer
{
    public class Server
    {
        public string Test(string str)
        {
            return str + "modi";
        }

        #region Fields / Constructors

        string pathLibrary = Application.StartupPath + @"\csharpdll\";
        string command = string.Empty;
        public static string CurrentDirectory = Directory.GetCurrentDirectory(), SqlDirectory, UploadDirectory, WorkDirectory;
        public string cname = string.Empty;
        public bool ViewGenerate = true;
        public UserConnection usercon;
        public SqlConnection sqlcon;
        public DefaultDataTable psgDataTable;
        public static string PsgGuid = string.Empty;
        public static string loginname = string.Empty;
        public object obj = null, objDebug = null;
        public string mainConnection = "Driver={PostgreSQL ODBC Driver(UNICODE)};Server=localhost;Database=elt;Port=5432;Uid=postgres;Pwd=postgres;SSL=No;";
        public bool debug = false;

        public Server()
        {
            Utils.server = this;
            sqlcon = new SqlConnection(this);
            psgDataTable = new DefaultDataTable();
            usercon = new UserConnection();

            debug = false;

            Server.CurrentDirectory = Directory.GetCurrentDirectory();  //@"D:\!psgcsharp\!Electrotel\csharpdll";
            Server.SqlDirectory = Server.CurrentDirectory + @"\..\sql\";
            Server.UploadDirectory = Server.CurrentDirectory + @"\..\uploads\";
            Server.WorkDirectory = Server.CurrentDirectory + @"\..\work_\";
            this.obj = usercon.obj;
        }

        public Server(string serverCurrentDirectory)
        {
            Utils.server = this;
            sqlcon = new SqlConnection(this);
            psgDataTable = new DefaultDataTable();
            usercon = new UserConnection();
            Server.CurrentDirectory = serverCurrentDirectory;

            debug = false;

            Server.SqlDirectory = Server.CurrentDirectory + @"\..\sql\";
            Server.UploadDirectory = Server.CurrentDirectory + @"\..\uploads\";
            Server.WorkDirectory = Server.CurrentDirectory + @"\..\work_\";
            this.obj = usercon.obj;
        }

        public Server(bool _debug)
        {
            sqlcon = new SqlConnection(this);
            usercon = new UserConnection();

            debug = _debug;

            Server.CurrentDirectory = Directory.GetCurrentDirectory();  //@"D:\!psgcsharp\!Electrotel\csharpdll";
            Server.SqlDirectory = Server.CurrentDirectory + @"\..\sql\";
            Server.WorkDirectory = Server.CurrentDirectory + @"\..\work_\";
            this.obj = usercon.obj;
        }

        #endregion

        #region From PsgServer

        public string RunCommandPsgDev(string cmd, object obj)
        {
            string result = string.Empty;
            string command = cmd.Split('#')[0];
            string param, param1, param2, param3, param4, param5;
            debug = true;

            try
            {
                sqlcon.Open();
                switch (command.ToLower())
                {
                    case "deleterecord":
                        param = cmd.Split('#')[1];
                        param1 = param.Split(',')[0].Replace("'","");
                        param2 = param.Split(',')[1].Replace("'", "");
                        param3 = param.Split(',')[2];

                        sqlcon.cmd.CommandText = string.Format(" delete from {0} where {1} = {2} ",param1, param2, param3);
                        sqlcon.cmd.ExecuteNonQuery();
                        result = "OK";
                        break;
                    case "updatefield":
                        param = cmd.Split('#')[1];
                        param1 = param.Split(',')[0].Replace("'", "");
                        param2 = param.Split(',')[1].Replace("'", "");
                        param3 = param.Split(',')[2];
                        param4 = param.Split(',')[3].Replace("'", "");
                        param5 = param.Split(',')[4];

                        sqlcon.cmd.CommandText = string.Format(" update {0} set {3} = {4} where {1} = {2} ", param1, param2, param3, param4, param5);
                        sqlcon.cmd.ExecuteNonQuery();
                        result = "OK";
                        break;
                    case "insert1":
                        param = cmd.Split('#')[1];
                        param1 = param.Split(',')[0].Replace("'", "");
                        param2 = param.Split(',')[1].Replace("'", "");
                        param3 = param.Split(',')[2];

                        sqlcon.cmd.CommandText = string.Format(" delete from {0} where {1} = {2} ", param1, param2, param3);
                        sqlcon.cmd.ExecuteNonQuery();
                        result = "OK";
                        break;
                    case "psginsert2":
                        //param = cmd.Split('#')[1];
                        //int count = param.Split('|').Length - 1;

                        //sqlcon.cmd.CommandText = string.Format(" insert into {0} values('') ", param);
                        //sqlcon.cmd.ExecuteNonQuery();

                        //for (int i = 0; i < count; i++)
                        //{
                        //    //param.Substring(
                        //    param1 = param.Split('|')[0].Replace("'", "");
                        //    param2 = param.Split('|')[1].Replace("'", "");
                        //}

                        //param3 = param.Split(',')[2];

                        //sqlcon.cmd.CommandText = string.Format(" delete from {0} where {1} = {2} ", param1, param2, param3);
                        //sqlcon.cmd.ExecuteNonQuery();
                        //result = "OK";
                        break;
                }
            }
            catch (Exception ex)
            {
                result = ex.Message;
            }
            finally
            {
                sqlcon.Close();
            }

            return result;
        }

        public string RunCommandDev(string cmd, string guid, object obj)
        {
            debug = true;
            Server.PsgGuid = guid;
            return this.RunCommand(cmd, "csharp+", Server.CurrentDirectory, this.main_connection, obj);
        }
        public string RunCommand(string _cmd, string type, string path, string mc, object _obj)
        {

            // set current thread
            Utils.NumberDecimalSeparator = Thread.CurrentThread.CurrentCulture.NumberFormat.NumberDecimalSeparator;
            Thread.CurrentThread.CurrentCulture = new CultureInfo("it-IT");
            Thread.CurrentThread.CurrentCulture.DateTimeFormat.ShortDatePattern = "dd.MM.yyy";
            Thread.CurrentThread.CurrentCulture.DateTimeFormat.LongDatePattern = "dd.MM.yyyy hh:mm:ss";
            Thread.CurrentThread.CurrentCulture.NumberFormat.NumberDecimalSeparator = Utils.NumberDecimalSeparator;

            Utils.server = this;
            string[] _params, _paramsMethod = null;
            this.mainConnection = mc;

            if (_obj != null)
            {
                usercon.obj = _obj;
                this.obj = _obj;
            }

            try
            {
                if (!string.IsNullOrEmpty(_cmd))
                {
                    #region Parameters from client

                    command = _cmd.Split('#')[0];
                    _params = _cmd.Split('#')[1].Split(',');

                    if (_params.Length > 0)
                    {
                        loginname = _params[_params.Length - 1];
                        loginname = loginname.Substring(1, loginname.Length - 2);

                        if (_cmd.Split('#')[1].Contains("'_"))
                        {
                            PsgGuid = _params[_params.Length - 2];
                            PsgGuid = PsgGuid.Substring(1, PsgGuid.Length - 2);

                            if (_params.Length > 3)
                            {
                                _paramsMethod = new string[_params.Length - 3];
                                for (int i = 1; i < _params.Length - 2; i++)
                                    _paramsMethod[i - 1] = _params[i];
                            }
                        }
                        else
                        {
                            if (_params.Length > 1)
                            {
                                _paramsMethod = new string[_params.Length - 1];
                                for (int i = 0; i < _params.Length - 1; i++)
                                    _paramsMethod[i] = _params[i];
                            }
                        }
                    }

                    #endregion

                    if (type.ToLower() == TypeCommand.CSharpPlus)
                        return this.InvokeAppServices(command, _paramsMethod);

                    #region PsgCommand

                    if (!File.Exists(pathLibrary + string.Format("{0}.cs", command)))
                        return string.Format("Web service '{0}' not exist!", command);

                    if (!File.Exists(pathLibrary + string.Format("{0}.dll", command)))
                    {
                        #region Create command file

                        FileStream fs1 = new FileStream(pathLibrary + string.Format("{0}.cs", command), FileMode.Open);
                        FileStream fs2 = new FileStream(pathLibrary + "psgserver.txt", FileMode.Open);

                        StreamReader sr1 = new StreamReader(fs1);
                        string str1 = sr1.ReadToEnd();
                        sr1.Close();

                        StreamReader sr2 = new StreamReader(fs2);
                        string str2 = sr2.ReadToEnd();
                        sr2.Close();

                        File.Delete(pathLibrary + string.Format("{0}.cs", command));
                        StreamWriter sw = new StreamWriter(pathLibrary + string.Format("{0}.cs", command));
                        sw.Write(str2.Replace("strfile", str1));
                        sw.Flush();
                        sw.Close();

                        ProcessStartInfo psi = new ProcessStartInfo("cmd.exe", string.Format(@"/C csc /reference:psgservices.dll /target:library {0}.cs", command));
                        psi.WindowStyle = ProcessWindowStyle.Hidden;
                        psi.WorkingDirectory = pathLibrary;
                        System.Diagnostics.Process.Start(psi);

                        #endregion
                    }

                    #endregion
                }

                #region PsgCommand

                int nr = 0;
                while (!File.Exists(pathLibrary + string.Format("{0}.dll", command)) && nr <= 5)
                {
                    ProcessStartInfo psi = new ProcessStartInfo("cmd.exe", string.Format(@"/C csc /reference:psgservices.dll /target:library {0}.cs", command));
                    psi.WindowStyle = ProcessWindowStyle.Hidden;
                    psi.WorkingDirectory = pathLibrary;
                    System.Diagnostics.Process.Start(psi);
                    System.Threading.Thread.Sleep(1000);
                    nr += 1;
                }

                return RunMethod(pathLibrary + string.Format("{0}.dll", command), command, _paramsMethod);

                #endregion
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }
        public string RunMethod(string _filename, string _methodname, string[] param1)
        {
            string pathFileName = _filename;
            string _params = string.Empty;

            foreach (string p in param1)
            {
                if (!string.IsNullOrEmpty(_params))
                    _params = _params + "," + p;
                else
                    _params = p;
            }

            try
            {
                #region Call method

                Assembly asm = Assembly.LoadFrom(pathFileName);

                foreach (Type t in asm.GetTypes())
                {
                    object plugObject = Activator.CreateInstance(t);
                    MethodInfo theMethod = t.GetMethod(_methodname);
                    if (theMethod != null)
                    {
                        string rez = theMethod.Invoke(plugObject, new object[] { param1 }).ToString();
                        return rez;

                    }
                    else
                        return string.Format("Command '{0}' not found.", _methodname);
                }

                #endregion
            }
            catch (Exception ex)
            {
                return ex.Message;
            }

            return "";
        }
        public string InvokeAppServices(string command, object[] param)
        {
            if (param == null)
                param = new object[1];

            try
            {
                AppServices bfl = new AppServices();
                cname = command;

                MethodInfo theMethod = typeof(AppServices).GetMethod(command);
                if (theMethod != null)
                {
                    ParameterInfo[] paramsMethod = theMethod.GetParameters();
                    object[] _params = new object[param.Length];

                    if (param.Length >= 1 && paramsMethod.Length == 1)
                        return theMethod.Invoke(bfl, new object[] { param }).ToString();

                    foreach (ParameterInfo pi in paramsMethod)
                    {
                        try
                        {
                            if (param.Length > pi.Position)
                                _params[pi.Position] = Convert.ChangeType(param[pi.Position], pi.ParameterType);
                        }
                        catch (Exception ex)
                        {
                            return smsg(string.Format(" Invalid parameter: {0}. Details: {1} ", pi.Name, ex.Message));
                        }
                    }

                    return theMethod.Invoke(bfl, _params).ToString();

                }
                else
                    throw new Exception("Method '" + command + "' not found.");

            }
            catch (Exception ex)
            {
                this.smsg(ex.Message);
            }

            return string.Empty;
        }

        public void LoadDataTable(object nameEntity, object fieldKeyEntity, object[] param, string connString)
        {
            try
            {
                sqlcon.connectionString = connString;

                foreach (Type t in Assembly.GetExecutingAssembly().GetTypes())
                {
                    if (t.Name.ToLower() == "defaultdatatable")
                    {
                        object plugObject = Activator.CreateInstance(t);
                        MethodInfo theMethod = t.GetMethod("Load");
                        if (theMethod != null)
                        {
                            try
                            {
                                theMethod.Invoke(plugObject, new object[] { nameEntity, fieldKeyEntity, param, OutFileName });
                            }
                            catch (Exception ex)
                            {
                                smsg(ex.InnerException.Message);
                            }
                        }
                        else
                            throw new Exception("Method 'Load' not found.");
                    }
                }
            }
            catch (Exception ex)
            {
                this.smsg(ex.Message);
            }
        }
        public void LoadDataSet(object nameEntity, object fieldKeyEntity, object[] param, string connString)
        {
            try
            {
                this.LoadInternal(nameEntity.ToString(), fieldKeyEntity.ToString(), param, connString);
            }
            catch (Exception ex)
            {
                this.smsg(ex.Message);
            }
        }
        public void LoadList(object nameEntity, object fieldKeyEntity, object[] param, string connString)
        {
            try
            {
                this.LoadInternal(nameEntity.ToString(), fieldKeyEntity.ToString(), param, connString);
            }
            catch (Exception ex)
            {
                this.smsg(ex.Message);
            }
        }
        public void LoadInternal(string nameEntity, string fieldKeyEntity, object[] param, string connString)
        {
            sqlcon.connectionString = connString;
            bool found = false;

            foreach (Type t in Assembly.GetExecutingAssembly().GetTypes())
            {
                if (t.Name.ToLower() == nameEntity.ToString().ToLower())
                {
                    found = true;
                    object plugObject = Activator.CreateInstance(t);
                    MethodInfo theMethod = t.GetMethod("Load");
                    if (theMethod != null)
                    {
                        try
                        {
                            theMethod.Invoke(plugObject, new object[] { param, OutFileName });
                        }
                        catch (Exception ex)
                        {
                            smsg(ex.InnerException.Message);
                        }
                    }
                    else
                        throw new Exception("Method 'Load' not found.");
                }
            }

            if (!found)
            {
                if (this.ViewGenerate && (param[0].ToString().Contains("null")))
                {
                    foreach (Type t in Assembly.GetExecutingAssembly().GetTypes())
                    {
                        if (t.Name.ToLower() == "defaultdatatable")
                        {
                            object plugObject = Activator.CreateInstance(t);
                            MethodInfo theMethod = t.GetMethod("Load");
                            if (theMethod != null)
                            {
                                try
                                {
                                    theMethod.Invoke(plugObject, new object[] { nameEntity, fieldKeyEntity, param, OutFileName });
                                }
                                catch (Exception ex)
                                {
                                    smsg(ex.InnerException.Message);
                                }
                            }
                            else
                                throw new Exception("Method 'Load' not found.");
                        }
                    }
                }
                else
                    throw new Exception("Class '" + nameEntity + "' not found.");
            }
        }

        public void save(object typeSave, object nameEntity, object fileXmlEntity, string connString)
        {
            try
            {
                switch (Convert.ToInt32(typeSave))
                {
                    case 1:
                        this.SaveInternal("DefaultDataTable", fileXmlEntity.ToString(), connString);
                        break;
                    case 2:
                        this.SaveInternal(nameEntity.ToString(), fileXmlEntity.ToString(), connString);
                        break;
                    case 3:
                        this.SaveInternal(nameEntity.ToString(), fileXmlEntity.ToString(), connString);
                        break;
                }

            }
            catch (Exception ex)
            {
                this.smsg(ex.Message);
            }
        }
        public void SaveInternal(string nameEntity, string fileXmlEntity, string connString)
        {
            sqlcon.connectionString = connString;

            foreach (Type t in Assembly.GetExecutingAssembly().GetTypes())
            {
                if (t.Name.ToLower() == nameEntity.ToString().ToLower())
                {
                    object plugObject = Activator.CreateInstance(t);
                    MethodInfo theMethod = t.GetMethod("Save");
                    if (theMethod != null)
                    {
                        theMethod.Invoke(plugObject, new object[] {fileXmlEntity }).ToString();
                    }
                }
            }
        }

        #endregion

        #region To PSG server

        public string smsg(string msg)
        {
            if (!debug && obj != null)
                obj.GetType().InvokeMember("smsg", BindingFlags.GetProperty, null, obj, new object[] { msg });
            // else
            // objDebug.GetType().InvokeMember("smsg", BindingFlags.GetProperty, null, obj, new object[] { msg });

            return msg;
        }

        public string main_connection
        {
            get
            {
                if (!debug && obj != null)
                    return (string)obj.GetType().InvokeMember("main_connection", BindingFlags.GetProperty, null, obj, null);
                else
                    return mainConnection;
            }
        }

        public string accept(string cmd)
        {
            if (!debug && obj != null)
                return (string)obj.GetType().InvokeMember("accept", BindingFlags.GetProperty, null, obj, new object[] { cmd });
            else
                return "";
        }

        public string getuserprop(string loginname, string property)
        {
            if (!debug && obj != null)
                return (string)obj.GetType().InvokeMember("getuserprop", BindingFlags.GetProperty, null, obj, new object[] { loginname, property });
            else
                return "";
        }

        public string Result
        {
            get
            {
                return cname + Server.PsgGuid;
            }
        }

        public string OutFileName
        {
            get
            {
                string str = string.IsNullOrEmpty(cname) ? Server.PsgGuid : cname + Server.PsgGuid;
                return WorkDirectory + str;
            }
        }

        #endregion

        #region  Debug port web

        static public string DecodeFrom64(string encodedData)
        {
            byte[] encodedDataAsBytes = System.Convert.FromBase64String(encodedData);
            string returnValue = System.Text.ASCIIEncoding.ASCII.GetString(encodedDataAsBytes);
            return returnValue;
        }
        //public string RunCommandDebug(string _cmd, object _objDebug)
        //{
        //    objDebug = _objDebug;
        //    _cmd = DecodeFrom64(_cmd);

        //    smsg(_cmd);
        //    string str = _cmd.Substring(_cmd.IndexOf("mainconnection", 0));
        //    _cmd = _cmd.Replace(str, "");
        //    smsg(_cmd);

        //    this.mainConnection = str.Replace("mainconnection", "");
        //    smsg(this.mainConnection);

        //    return this.RunCommand(_cmd, null);
        //}

        #endregion

        #region Utils

        public string LoadDefault(string nameEntity, string fieldKeyEntity, object[] param)
        {
            Utils.server = this;
            DefaultDataTable ddt = new DefaultDataTable();
            ddt.Load(nameEntity, fieldKeyEntity, param, OutFileName);

            return Result;
        }

        public void Serialize(DataTable dt, string fileName)
        {
            dt.WriteXmlSchema(fileName + ".xsd");
            XmlSerializer ser = new XmlSerializer(typeof(DataTable));
            TextWriter writer = new StreamWriter(fileName + ".xml");
            ser.Serialize(writer, dt);
            writer.Close();
        }

        public void Serialize<T>(T t, string fileName)
        {
            XmlSerializer xmlSerializer = new XmlSerializer(typeof(T));
            TextWriter writer = new StreamWriter(fileName + ".xml");
            xmlSerializer.Serialize(writer, t);
            writer.Close();
        }

        public T Deserialize<T>(string fileName)
        {
            XmlSerializer xmlSerializer = new XmlSerializer(typeof(T));
            FileStream readStream = new FileStream(Server.SqlDirectory + fileName + ".xml", FileMode.Open);
            object t = xmlSerializer.Deserialize(readStream);
            readStream.Close();

            return (T)t;
        }

        // typeSave, nameEntity, fileXmlEntity
        public string PSGSAVECS(object[] param)
        {
            AppServices services = new AppServices();
            return services.PSGSAVECS(param);
        }

        #endregion
    }

    public class TypeCommand
    {
        public static string CSharp = "csharp";
        public static string CSharpPlus = "csharp+";
    }
}
